% beispiele.m
% Kapitel 2: MATLAB Grundlagen
%            Beispiele zum Skript

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
format compact      % Ermglicht kompakte Ausgabe ohne Leerzeilen
echo on             % Ermglicht Ausgabe aller Zeilen im Command Window

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2.1 Erste Schritte mit MATLAB

(40^3 + 3*2e3) / 7

%% Hilfe

help sqrt

%% Zuweisungen

variable_1 = 25;
variable_2 = 10;
variable_1

a = variable_1 + variable_2, A = variable_1 / variable_2

1 / 0           % inf: Unendlich
0 / 0           % NaN: Nicht definiert

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2.2 Variablen
%      Vektoren und Matrizen

mein_vektor = [1 2 3]
meine_matrix = [mein_vektor; 5 6 7]

lang = 1:8
tief = 10:-2:0
noch_laenger = linspace (1, 19, 10)
hoch_hinaus = logspace (1, 2, 5)
zwo_drei = ones (2, 3)

meine_matrix (2, 3)
meine_matrix (2, :)
meine_matrix (end)
meine_matrix (end, :)
M = meine_matrix;
M (:, end+1) = [10; 11]

zufall = rand (2, 3)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Mathematische Funktionen und Operatoren fr Vektoren und Matrizen

zwo_drei * meine_matrix'
zwo_drei ./ meine_matrix

komplex = [1+i 1-i; 2 3]
komplex .* komplex

diff (mein_vektor)

rangvoll = [1 2; 4 9]
det (rangvoll)
rank (rangvoll)
eig (rangvoll)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Strukturen

meine_struktur = struct ('daten', meine_matrix, 'groesse', [2 3]);
meine_struktur.daten(1,:)

komponist = struct ('name', 'Johann Sebastian Bach');
datum.Tag = 21;
datum.Monat = 'Mrz';
datum.Jahr = 1685;
komponist.geboren = datum;

komponist(2).name = 'Wolfgang Amadeus Mozart';
komponist(2).geboren.Tag = 27;
komponist(2).geboren.Monat = 'Januar';
komponist(2).geboren.Jahr = 1756;

komponist(2)
komponist(2).geboren

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Cell Arrays

zelle = cell (2, 3)

zelle {1, 1} = 'Zelle (1, 1) ist ein Text';
zelle {1, 2} = 10;
zelle {1, 3} = [1 2; 3 4];
zelle {2, 1} = komponist(2);
zelle {2, 3} = date;

zelle
zelle{2, 3}                                        % kein Leerzeichen vor { !
zelle{2, 1}.geboren.Monat                          % kein Leerzeichen vor { !

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Verwalten von Variablen

length (meine_matrix)
size (meine_matrix)

clear variable_1 variable_2 a A meine_matrix lang tief noch_laenger ...
      hoch_hinaus zwo_drei M zufall rangvoll datum ans
whos

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2.3 Ablaufsteuerung
%      Vergleichsoperationen und logische Operatoren

mein_vektor >= 2
1 == 0 | (4 > 5-2 & 4 <= 5)

a = [0 0 1 1]';
b = [0 1 0 1]';
[ a     b   a&b   a|b xor(a,b) ~a ~(a&b) ~(a|b)]

%% Logical Indexing

a = -2:7
a (a < 0) = 0
a = a (logical (mod (a, 3)))

% Alternative: ~ wandelt in logical um, [] lscht Element
% a (mod (a, 3)) = []

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Verzweigungen und Schleifen

test = 5;
if test <= 2
    a = 2
elseif test <= 5
    a = 5
else a = 10
end

switch test
    case 2,       a =  2
    case {3 4 5}, a =  5
    otherwise     a = 10
end

for k=1:0
    k^2
end

n = 1;
while 1
    n = n + 1;
    m = n^2 
    if m > 5
        break
    end
end

%% Primzahlen-Berechnung

for m = 13:2:17
    for n = 2:m-1
        if mod(m,n) ~= 0
            continue
        end
        sprintf ('   %2d ist keine Primzahl.\n', m)
        break
    end % n
    if n == m-1
        sprintf ('!! %2d IST eine  Primzahl!\n', m)
    end % if
end % m

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2.5 MATLAB--Funktionen
%      siehe auch Datei mittelwerte.m

test = [2 4 3];
[A, G] = mittelwerte (test)

%% Funktionen mit variabler Parameterzahl
%      siehe auch Datei mittelwerte2.m

mittelwerte2 (test, 'g')

%% Lokale und globale Variablen
%      siehe auch Datei mittelwerte3.m

global schalter
schalter = 'g';
[M1, M2] = mittelwerte3 (test)

whos global

%% Hilfetext in Funktionen
%      siehe auch Datei mittelwerte.m

help mittelwerte

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Function Handles
%      (fr Fortgeschrittene)

fh = @mittelwerte;                   % function_handle auf @det erzeugen
feval (fh, test)                     % Ausfhren des function_handles fh
A = fh (test)                        % Ausfhren des function_handles fh

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Funktionen als Inline Object

f1 = inline ('x.^2+x-1', 'x')        % Inline Object Funktion
test = [2 4 3];
f1 (test)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
echo off
format
