% loesungen.m
% Kapitel 2: MATLAB Grundlagen
%            Lsungen zu den bungsaufgaben

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2.7.1 Rechengenauigkeit

format long g      % Gnstige Zahlendarstellung whlen

n = 1 + 1e-10
m = n^(2^32)       % Direkte Berechnung

for k = 1:32       % Berechnung mit Schleife
    n = n^2;
end
n                  % Ausgabe

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2.7.2 Fibonacci-Folge
%        Fibonacci-Folge mit For-Schleife

ausgabe = [1 1];
for k = 1:10
    ausgabe = [ausgabe ausgabe(k)+ausgabe(k+1)];
end
ausgabe

%% Fibonacci-Folge mit While-Schleife

ausgabe = [1 1];
while ausgabe (end) < 1e20
    ausgabe = [ausgabe ausgabe(end-1)+ausgabe(end)];
end
ausgabe (end)                 % Ausgabe letztes Element (Wert)
length (ausgabe)              % Ausgabe letztes Element (Index)

%% Fibonacci-Folge direkt

index = 12:20;
F = (1 + sqrt(5)) / 2;
ausgabe = (F.^index - (1-F).^index) / sqrt(5);   % Elementweise Operation !
round (ausgabe)                                  % Unterdrckung Nachkommastellen

format                        % Ausgabe wieder mit Standard-Einstellung

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2.7.3 Funktion gerade
%        siehe auch Datei gerade.m

[steigung, y0, r, phi] = gerade (-1, 3)
[steigung, y0]         = gerade (-1, 1, 3, -2)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% 2.7.4 Berechnungszeiten ermitteln
%        siehe auch Dateien mittelwerte_zeit.m, mittelwerte.m, mittelwerte2.m

mittelwerte_zeit

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
