%GERADE Geradengleichung aus Koordinaten bestimmen.
%
%   [m,y0] = GERADE(x1,y1,x2,y2) berechnet aus den beiden kartesischen 
%   Koordinaten P1 (x1,y1) und P2 (x2,y2) einer Gerade die Parameter 
%   m und y0 der Geradengleichung y = m * x + y0.
%
%   [m,y0,r,phi] = GERADE(x1,y1) berechnet aus den kartesischen 
%   Koordinaten P1 (x1,y1) die Paramter m und y0 der Geradengleichung 
%   y = m * x sowie den Abstand r des Punktes P1 vom Koordinatenursprung 
%   und seinen Winkel phi zur x-Achse in Grad. 

% gerade.m
% Kapitel 2.7.3 bungsaufgaben

function [steigung, y0, r, phi] = gerade (x1, y1, x2, y2)

if nargin == 2
    y0     = 0;
    r      = sqrt (x1^2 + y1^2);
    if x1 == 0 
        disp ('Steigung unendlich!')
        steigung = sign(y1) * inf;
        phi      = sign(y1) * pi/2 * 180/pi;
        return
    end
    steigung = y1 / x1;
    phi      = sign(y1) * atan2(y1,x1) * 180/pi;
    
elseif nargin == 4
    if x1 == x2 
        disp ('Steigung unendlich!')
        steigung = sign(y2-y1) * inf;
        y0       = [];
        return
    end
    steigung = (y2-y1) / (x2-x1);
    y0       = (x2*y1 - x1*y2) / (x2-x1);
    r        = [];
    phi      = [];
    
else
    disp ('Falsche Anzahl von Parametern!')
    help gerade
end
